#include <WiFi.h>
#include "HX711.h"

#define calibration_factor -1740.0 //This value is obtained using the Calibration sketch

#define DOUT  26
#define CLK  25

HX711 scale;

// WiFi network name and password:
const char * networkName = "OSU_Access"; // Can use hotspots or wifi networks for connections
const char * networkPswd = NULL; // Password. Leave NULL if the network has no password

int ledPin = 2;

void setup()
{
  // Initilize hardware:
  pinMode(ledPin, OUTPUT);
  Serial.begin(9600);

  scale.begin(DOUT, CLK);
  scale.set_scale(calibration_factor); //This value is obtained by using the Calibration sketch
  scale.tare(); //Assuming there is no weight on the scale at start up, reset the scale to 0

  // Connect to the WiFi network (see function below loop)
  connectToWiFi(networkName, networkPswd);

  Serial.println("HX711 scale demo"); 
  Serial.println("Readings:");
}

void loop()
{
  float mass = scale.get_units() / 1000;
  float force = mass * 9.8;
  Serial.print("Reading: ");
  Serial.print(mass);
  Serial.print(" g, ");
  Serial.print(force); //scale.get_units() returns a float
  Serial.print(" N."); //You can change this to kg but you'll need to refactor the calibration_factor
  Serial.println();
}

void connectToWiFi(const char * ssid, const char * pwd)
{
  printLine();
  Serial.println("Connecting to WiFi network: " + String(ssid));

  WiFi.begin(ssid, pwd);

  while (WiFi.status() != WL_CONNECTED) 
  {
    // Blink LED while we're connecting:
    Serial.print(".");
    digitalWrite(ledPin, HIGH);
    delay(500);
    Serial.print(".");
    digitalWrite(ledPin, LOW);
    delay(500);
  }

  Serial.println();
  Serial.println("WiFi connected!");
  Serial.print("IP address: ");
  Serial.println(WiFi.localIP());
}


void printLine()
{
  Serial.println();
  for (int i=0; i<30; i++)
    Serial.print("-");
  Serial.println();
}
